#!/bin/sh

CHAP=6
APPNAME=gawk
VER=5.1.0
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

. ./_lfsset.sh

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

sed -i 's/extras//' Makefile.in

echo \ \ Configuring...
./configure --prefix=/usr   \
            --host=$LFS_TGT \
            --build=$(./config.guess) \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
make DESTDIR=$LFS install \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap6

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR

echo \ \ Done.
