#!/bin/sh

CHAP=6
APPNAME=gcc
APPVER=.2
VER=10.1.0
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

VER_mpfr=4.0.2
VER_gmp=6.2.0
VER_gmp2=${VER_gmp}
VER_mpc=1.1.0

. ./_lfsset.sh

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

cd $TARGETDIR

echo \ \ Extracting...
tar -xf $DLD/mpfr-$VER_mpfr.tar.xz || exit 1
mv mpfr-$VER_mpfr mpfr
tar -xf $DLD/gmp-${VER_gmp2}.tar.xz || exit 1
mv gmp-$VER_gmp gmp
tar -xf $DLD/mpc-$VER_mpc.tar.gz || exit 1
mv mpc-$VER_mpc mpc 

case $(uname -m) in
  x86_64)
    sed -e '/m64=/s/lib64/lib/' -i.orig gcc/config/i386/t-linux64
  ;;
esac

echo \ \ Patching...
patch -Np1 -i $DLD/gcc-$VER-cet_fix-1.patch \
	1> $LOG/$CHAP.$TARGET.0_patch.log 2>&1 || exit 1

TimeStart

mkdir build
cd    build

mkdir -p $LFS_TGT/libgcc
ln -s ../../../libgcc/gthr-posix.h $LFS_TGT/libgcc/gthr-default.h

echo \ \ Configuring...
../configure                                       \
    --build=$(../config.guess)                     \
    --host=$LFS_TGT                                \
    --prefix=/usr                                  \
    CC_FOR_TARGET=$LFS_TGT-gcc                     \
    --with-build-sysroot=$LFS                      \
    --enable-initfini-array                        \
    --disable-nls                                  \
    --disable-multilib                             \
    --disable-decimal-float                        \
    --disable-libatomic                            \
    --disable-libgomp                              \
    --disable-libquadmath                          \
    --disable-libssp                               \
    --disable-libvtv                               \
    --disable-libstdcxx                            \
    --enable-languages=c,c++                       \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
make DESTDIR=$LFS install \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

ln -sv gcc $LFS/usr/bin/cc \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap6

echo \ \ Removing directory...
cd ../..
rm -fr $TARGETDIR

echo \ \ Done.
