#!/bin/sh

CHAP=6
APPNAME=ncurses
VER=6.2
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

. ./_lfsset.sh

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

sed -i s/mawk// configure

mkdir build
pushd build >/dev/null
echo \ \ Configuring \(pre\)...
  ../configure \
	1> $LOG/$CHAP.$TARGET.0_pre.log 2>&1 || exit 1
  echo \ \ Making \(pre\)...
  make -C include \
	1>> $LOG/$CHAP.$TARGET.0_pre.log 2>&1 || exit 1
  make -C progs tic    \
	1>> $LOG/$CHAP.$TARGET.0_pre.log 2>&1 || exit 1
popd > /dev/null

echo \ \ Configuring...
./configure --prefix=/usr                \
            --host=$LFS_TGT              \
            --build=$(./config.guess)    \
            --mandir=/usr/share/man      \
            --with-manpage-format=normal \
            --with-shared                \
            --without-debug              \
            --without-ada                \
            --without-normal             \
            --enable-widec               \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
make DESTDIR=$LFS TIC_PATH=$(pwd)/build/progs/tic install \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
ln -s libncursesw.so $LFS/usr/lib/libncurses.so \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
mv -v $LFS/usr/lib/libncursesw.so.6* $LFS/lib \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
ln -sfv ../../lib/$(readlink $LFS/usr/lib/libncursesw.so) $LFS/usr/lib/libncursesw.so \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap6

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR

echo \ \ Done.
