#!/bin/sh

CHAP=8
APPNAME=coreutils
VER=8.32
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo \ \ Patching...
patch -Np1 -i $DLD/coreutils-$VER-i18n-1.patch \
	1> $LOG/$CHAP.$TARGET.0_patch.log 2>&1 || exit 1

sed -i '/test.lock/s/^/#/' gnulib-tests/gnulib.mk

echo \ \ Autoconfing...
autoreconf -fiv \
	1> $LOG/$CHAP.$TARGET.0_auto.log 2>&1 || exit 1

echo \ \ Configuring...
FORCE_UNSAFE_CONFIGURE=1 ./configure \
            --prefix=/usr            \
            --enable-no-install-program=kill,uptime \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
porg -lp  $TARGET "make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
mv -v /usr/bin/{cat,chgrp,chmod,chown,cp,date,dd,df,echo} /bin" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
mv -v /usr/bin/{false,ln,ls,mkdir,mknod,mv,pwd,rm} /bin" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
mv -v /usr/bin/{rmdir,stty,sync,true,uname} /bin" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
mv -v /usr/bin/chroot /usr/sbin" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
mv -v /usr/share/man/man1/chroot.1 /usr/share/man/man8/chroot.8" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
sed -i s/\"1\"/\"8\"/1 /usr/share/man/man8/chroot.8" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
mv -v /usr/bin/{head,nice,sleep,touch} /bin" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap8

echo -n \ \ Porging:\   && porg $TARGET || echo none

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR

echo \ \ Done.
