#!/bin/sh

CHAP=8
APPNAME=dejagnu
VER=1.6.2
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

. ./_lfsset.sh

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo \ \ Configuring...
./configure --prefix=/usr \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

makeinfo --html --no-split -o doc/dejagnu.html doc/dejagnu.texi \
	1> $LOG/$CHAP.$TARGET.2_info.log 2>&1 || exit 1
makeinfo --plaintext       -o doc/dejagnu.txt  doc/dejagnu.texi \
	1>> $LOG/$CHAP.$TARGET.2_info.log 2>&1 || exit 1

echo \ \ Installing...
porg -lp $TARGET "\
make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
install -v -dm755  /usr/share/doc/dejagnu-$VER" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
install -v -m644   doc/dejagnu.{html,txt} /usr/share/doc/dejagnu-$VER" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap8

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR

echo -n \ \ Porging:\   && porg $TARGET || echo none

echo \ \ Done.
