#!/bin/sh

CHAP=8
APPNAME=expect
VER=5.45.4
TARGET=$APPNAME$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

. ./_lfsset.sh

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo \ \ Configuring...
./configure --prefix=/usr           \
            --with-tcl=/usr/lib     \
            --enable-shared         \
            --mandir=/usr/share/man \
            --with-tclinclude=/usr/include \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
porg -lp $TARGET "make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap8

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR

echo -n \ \ Porging:\   && porg $TARGET || echo none

echo \ \ Done.
