#!/bin/sh

CHAP=8
APPNAME=gmp
VER=6.2.0
VER2=${VER}
TARGET=gmp-${VER2}
TARGETBALL=$TARGET.tar.xz
TARGETDIR=gmp-$VER

echo $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo \ \ Configuring...
./configure --prefix=/usr    \
            --enable-cxx     \
            --disable-static \
            --docdir=/usr/share/doc/gmp-${VER2} \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1
#make html \
#	1>> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
porg -lp $TARGET -E`pwd` "make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
#porg -lp+ $TARGET "\
#make install-html" \
#	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap8

echo -n \ \ Porging:\   && porg $TARGET || echo none

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR

echo \ \ Done.
