#!/bin/sh

CHAP=8
APPNAME=libcap
VER=2.36
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

sed -i '/install.*STALIBNAME/d' libcap/Makefile

echo \ \ Making...
make lib=lib -j1 \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
porg -lp $TARGET "\
make lib=lib PKGCONFIGDIR=/usr/lib/pkgconfig install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
chmod 755 /lib/libcap.so.$VER

porg -lp+ $TARGET "\
mv -v /lib/libpsx.a /usr/lib" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
rm -v /lib/libcap.so" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
ln -sfv ../../lib/libcap.so.2 /usr/lib/libcap.so" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap8

echo -n \ \ Porging:\   && porg $TARGET || echo none

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR

echo \ \ Done.
