#!/bin/sh

CHAP=8
APPNAME=meson
VER=0.54.3
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo \ \ Building
python3 setup.py build \
	1> $LOG/$CHAP.$TARGET.2_build.log 2>&1 || exit 1

echo \ \ Installing...
python3 setup.py install --root=dest \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

porg -lp $TARGET -E`pwd` "\
cp -rv dest/* /" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap8

echo -n \ \ Porging:\   && porg $TARGET || echo none

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR

echo \ \ Done.
