#!/bin/sh

CHAP=8
APPNAME=tcl
VER=8.6.10
TARGET=$APPNAME-$VER
TARGETBALL=$APPNAME$VER-src.tar.gz
TARGETDIR=$APPNAME$VER

. ./_lfsset.sh

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

tar -xf $DLD/tcl8.6.10-html.tar.gz --strip-components=1 || \
	(echo Document tarball error && exit 1)

echo \ \ Configuring...
SRCDIR=$(pwd)
cd unix
./configure --prefix=/usr           \
            --mandir=/usr/share/man \
            $([ "$(uname -m)" = x86_64 ] && echo --enable-64bit) \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

sed -e "s|$SRCDIR/unix|/usr/lib|" \
    -e "s|$SRCDIR|/usr/include|"  \
    -i tclConfig.sh

sed -e "s|$SRCDIR/unix/pkgs/tdbc1.1.1|/usr/lib/tdbc1.1.1|" \
    -e "s|$SRCDIR/pkgs/tdbc1.1.1/generic|/usr/include|"    \
    -e "s|$SRCDIR/pkgs/tdbc1.1.1/library|/usr/lib/tcl8.6|" \
    -e "s|$SRCDIR/pkgs/tdbc1.1.1|/usr/include|"            \
    -i pkgs/tdbc1.1.1/tdbcConfig.sh

sed -e "s|$SRCDIR/unix/pkgs/itcl4.2.0|/usr/lib/itcl4.2.0|" \
    -e "s|$SRCDIR/pkgs/itcl4.2.0/generic|/usr/include|"    \
    -e "s|$SRCDIR/pkgs/itcl4.2.0|/usr/include|"            \
    -i pkgs/itcl4.2.0/itclConfig.sh

unset SRCDIR

echo \ \ Installing...
porg -lp $TARGET "make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

chmod -v u+w /usr/lib/libtcl8.6.so \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

echo \ \ Installing...
porg -lp+ $TARGET "make install-private-headers" \
	1> $LOG/$CHAP.$TARGET.4_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
ln -sfv tclsh8.6 /usr/bin/tclsh" \
	1>> $LOG/$CHAP.$TARGET.4_install.log 2>&1 || exit 1

TimeEnd chap8

echo \ \ Removing directory...
cd ../..
rm -fr $TARGETDIR

echo -n \ \ Porging:\   && porg $TARGET || echo none

echo \ \ Done.
