#!/bin/sh

CHAP=8
APPNAME=texinfo
VER=6.7
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo \ \ Configuring...
./configure --prefix=/usr --disable-static \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1

echo \ \ Installing...
porg -lp $TARGET -E`pwd` "make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1

pushd /usr/share/info > /dev/null
rm dir
for f in *
do install-info $f dir 2>/dev/null
done
popd > /dev/null

TimeEnd chap8

echo \ \ Removing directory...
cd $SRC
rm -fr $TARGETDIR

echo -n \ \ Porging:\   && porg $TARGET || echo none

echo \ \ Done.
