#!/bin/sh

CHAP=8
APPNAME=vim
VER=8.2.0814
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo '#define SYS_VIMRC_FILE "/etc/vimrc"' >> src/feature.h

echo \ \ Configuring...
./configure --prefix=/usr \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1

echo \ \ Installing...
porg -lp $TARGET -E`pwd` "make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1

porg -lp+ $TARGET "ln -sv vim /usr/bin/vi" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1

for L in  /usr/share/man/{,*/}man1/vim.1; do
    porg -lp+ $TARGET "ln -sv vim.1 $(dirname $L)/vi.1" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1
done

#porg -lp+ $TARGET "\
#ln -sv ../vim/vim82/doc /usr/share/doc/vim-$VER" \
#	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1

cat > /etc/vimrc << "EOF"
" Begin /etc/vimrc

" Ensure defaults are set before customizing settings, not after
source $VIMRUNTIME/defaults.vim
let skip_defaults_vim=1

set nocompatible
set backspace=2
set mouse=r
set paste
syntax on
if (&term == "xterm") || (&term == "putty")
  set background=dark
endif

" End /etc/vimrc
EOF
porg -lp+ $TARGET "touch /etc/vimrc"

TimeEnd chap8

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR

echo -n \ \ Porging:\   && porg $TARGET || echo none

echo \ \ Done.
