#!/bin/sh

. ./_blfsset.sh

APPNAME=git
VER=2.2.2
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	openssl expat curl python
. $WRK/_checkOptions.sh  \
	pcre
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr         \
            --with-gitconfig=/etc/gitconfig \
	--with-openssl --with-curl --with-expat \
	$([ ${OPTION_pcre} -eq "1" ] && echo --with-libpcre) \
	1> $LOG/$TARGET.1_conf.log 2>&1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

