#!/bin/sh

. ./_blfsset.sh

APPNAME=glib
VER=2.42.1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	python pcre libffi
. $WRK/_checkOptions.sh  \
	attr dbus gtk-doc elfutils
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

LIBFIIVER=`porg libffi | sed s/libffi\-//`

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
#PCRE_LIBS=-lpcre  PCRE_CFLAGS=" "                                \
#LIBFFI_LIBS=-lffi LIBFFI_CFLAGS=" " \
./configure --prefix=/usr --with-pcre=system \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

