#!/bin/sh

. ../_blfsset.sh
. ../Xorg/_xorgset.sh
. ./_gnomeset.sh

APPNAME=folks
VER=0.8.0
TARGET=$APPNAME-$VER
TARGETBALL=$GNOMEDLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	gobject-introspection intltool \
        libgee libzeitgeist telepathy-glib
. $WRK/_checkOptions.sh  \
	evolution-data-server vala \
	libsocialweb tracker valadoc
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
	$([ ${OPTION_vala} -eq 1 ] && echo --enable-vala) \
	$([ ${OPTION_tracker} -eq 1 ] && echo --enable-tracker-backend) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

