#!/bin/sh

. ./_blfsset.sh

APPNAME=psutils
TARGET=$APPNAME-p17
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=psutils

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

sed 's@/usr/local@/usr@g' Makefile.unix > Makefile

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

