#!/bin/sh

. ./_blfsset.sh
. ./Xorg/_xorgset.sh

APPNAME=qt
APPVER=4
VER=4.8.6
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/qt-everywhere-opensource-src-$VER.tar.gz
TARGETDIR=qt-everywhere-opensource-src-$VER

echo $TARGET

. $WRK/_checkRequired.sh \
	Xorg-lib-libX11
. $WRK/_checkOptions.sh  \
	dbus libjpeg-turbo libmng tiff libpng \
        pkg-config \
	gst-plugins-base-0 pulseaudio glib-2 gtk+-2 openssl \
	cups mysql postgresql unixODBC sqlite
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

sed -i -e '631a if (image->isNull()) { state = Error; return -1; }' \
    src/gui/image/qgifhandler.cpp
sed -i -e "/#if/d" -e "/#error/d" -e "/#endif/d" \
     config.tests/unix/libmng/libmng.cpp
sed -i '/CONFIG -/ a\isEmpty(OUTPUT_DIR): OUTPUT_DIR = ../..' \
     src/3rdparty/webkit/Source/WebKit2/DerivedSources.pro

export QT4DIR=/opt/qt-$VER
export QT4LINK=/opt/qt4

Configuring
./configure -prefix $QT4DIR      \
            -sysconfdir /etc/xdg \
            -confirm-license     \
            -opensource          \
            -release             \
            -dbus-linked         \
            -openssl-linked      \
            -system-sqlite       \
            -plugin-sql-sqlite   \
            -no-phonon           \
            -no-phonon-backend   \
            -no-nis              \
            -no-openvg           \
            -nomake demos        \
            -nomake examples     \
            -optimized-qmake     \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
ln -svfn $QT4DIR /opt/qt4" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

cat >> /etc/ld.so.conf << "EOF"
# Begin Qt addition

/opt/qt4/lib

# End Qt addition
EOF
ldconfig

cat > /etc/profile.d/qt4.sh << "EOF"
# Begin /etc/profile.d/qt4.sh

QT4DIR=/opt/qt4

pathappend /opt/qt4/bin           PATH
pathappend /opt/qt4/lib/pkgconfig PKG_CONFIG_PATH

export QT4DIR

# End /etc/profile.d/qt4.sh
EOF
paco -p+ $TARGET "touch /etc/profile.d/qt4.sh"

for file in `basename -a -s .prl $QT4DIR/lib/lib*.prl`; do
       sed -r -e '/^QMAKE_PRL_BUILD_DIR/d'    \
              -e 's/(QMAKE_PRL_LIBS =).*/\1/' \
              -i $QT4DIR/lib/${file}.prl

   perl -pi -e "s, -L$PWD/?\S+,,g" $QT4DIR/lib/pkgconfig/${file##lib}.pc
done

unset file

paco -p+ $TARGET "\
install -v -Dm644 src/gui/dialogs/images/qtlogo-64.png \
                  /usr/share/pixmaps/qt4logo.png" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
install -v -Dm644 tools/assistant/tools/assistant/images/assistant-128.png \
                  /usr/share/pixmaps/assistant-qt4.png" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
install -v -Dm644 tools/designer/src/designer/images/designer.png \
                  /usr/share/pixmaps/designer-qt4.png" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
install -v -Dm644 tools/linguist/linguist/images/icons/linguist-128-32.png \
                  /usr/share/pixmaps/linguist-qt4.png" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
install -v -Dm644 tools/qdbus/qdbusviewer/images/qdbusviewer-128.png \
                  /usr/share/pixmaps/qdbusviewer-qt4.png" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

install -dm755 /usr/share/applications

cat > /usr/share/applications/assistant-qt4.desktop << EOF
[Desktop Entry]
Name=Qt4 Assistant 
Comment=Shows Qt4 documentation and examples
Exec=$QT4LINK/bin/assistant
Icon=assistant-qt4.png
Terminal=false
Encoding=UTF-8
Type=Application
Categories=Qt;Development;Documentation;
EOF
paco -p+ $TARGET "touch /usr/share/applications/assistant-qt4.desktop"

cat > /usr/share/applications/designer-qt4.desktop << EOF
[Desktop Entry]
Name=Qt4 Designer
Comment=Design GUIs for Qt4 applications
Exec=$QT4LINK/bin/designer
Icon=designer-qt4.png
MimeType=application/x-designer;
Terminal=false
Encoding=UTF-8
Type=Application
Categories=Qt;Development;
EOF
paco -p+ $TARGET "touch /usr/share/applications/designer-qt4.desktop"

cat > /usr/share/applications/linguist-qt4.desktop << EOF
[Desktop Entry]
Name=Qt4 Linguist 
Comment=Add translations to Qt4 applications
Exec=$QT4LINK/bin/linguist
Icon=linguist-qt4.png
MimeType=text/vnd.trolltech.linguist;application/x-linguist;
Terminal=false
Encoding=UTF-8
Type=Application
Categories=Qt;Development;
EOF
paco -p+ $TARGET "touch /usr/share/applications/linguist-qt4.desktop"

cat > /usr/share/applications/qdbusviewer-qt4.desktop << EOF
[Desktop Entry]
Name=Qt4 QDbusViewer 
GenericName=D-Bus Debugger
Comment=Debug D-Bus applications
Exec=$QT4LINK/bin/qdbusviewer
Icon=qdbusviewer-qt4.png
Terminal=false
Encoding=UTF-8
Type=Application
Categories=Qt;Development;Debugger;
EOF
paco -p+ $TARGET "touch /usr/share/applications/qdbusviewer-qt4.desktop"

cat > /usr/share/applications/qtconfig-qt4.desktop << EOF
[Desktop Entry]
Name=Qt4 Config 
Comment=Configure Qt4 behavior, styles, fonts
Exec=$QT4LINK/bin/qtconfig
Icon=qt4logo.png
Terminal=false
Encoding=UTF-8
Type=Application
Categories=Qt;Settings;
EOF
paco -p+ $TARGET "touch /usr/share/applications/qtconfig-qt4.desktop"

cat > /usr/bin/setqt4 << 'EOF'
if [ "x$QT5DIR" != "x/usr" ]; then pathremove  $QT5DIR/bin; fi
if [ "x$QT4DIR" != "x/usr" ]; then pathprepend $QT4DIR/bin; fi
echo $PATH
EOF
paco -p+ $TARGET "touch /usr/bin/setqt4"

cat > /usr/bin/setqt5 << 'EOF'
if [ "x$QT4DIR" != "x/usr" ]; then pathremove  $QT4DIR/bin; fi
if [ "x$QT5DIR" != "x/usr" ]; then pathprepend $QT5DIR/bin; fi
echo $PATH
EOF
paco -p+ $TARGET "touch /usr/bin/setqt5"

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

