#!/bin/sh

. ./_blfsset.sh

APPNAME=texlive
VER=20130530
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET-source.tar.xz
TARGETDIR=$TARGET-source

echo $TARGET

. $WRK/_checkRequired.sh \
	xpdf harfbuzz icu graphite2 \
	poppler freetype fontconfig libpng
. $WRK/_checkOptions.sh  \
	ghostscript t1lib libgd \
	Xorg-lib-libX11 \
	zziplib clisp lua teckit
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

INSTDIR=/opt/texlive
. $WRK/_texlive-funcs.sh

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

teckit
kpathsea
ptexenc
web2c
dvipdfmx
dvipsk
texlive

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

exit 0


