#!/bin/sh

. ./_blfsset.sh

APPNAME=tk
VER=8.6.1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$APPNAME$VER-src.tar.gz
TARGETDIR=$APPNAME$VER

echo $TARGET

. $WRK/_checkRequired.sh \
	tcl Xorg-lib-libX11
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
cd unix 
./configure --prefix=/usr \
            --mandir=/usr/share/man \
	$([ $(uname -m) = x86_64 ] && echo --enable-64bit) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

sed \
    -e "s@^\(TK_SRC_DIR='\).*@\1/usr/include'@" \
    -e "/TK_B/s@='\(-L\)\?.*unix@='\1/usr/lib@" \
    -i tkConfig.sh

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

echo Installing private headers...
paco -p+ $TARGET "make install-private-headers" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "ln -v -sf wish8.6 /usr/bin/wish"
chmod -v 755 /usr/lib/libtk8.6.so

TimeEnd

cd ../..
RemoveSrcDir
PacoingDone

