#/bin/sh

. ./_cblfsset.sh

APPNAME=wget
VER=1.14
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

checkRequired ""
checkOptions  \
	openssl gnutls libidn dante
checkTarball
checkExit "$1" || exit $?

cd $SRC

BIT64
RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Configuring...
CC="gcc ${BUILD64}" \
./configure --prefix=/usr --sysconfdir=/etc --libdir=/usr/lib64 \
--with-ssl=openssl \
        1> $LOG/$TARGET.$BIT.1_conf.log 2>&1 || exit 1

echo Making...
make \
        1> $LOG/$TARGET.$BIT.2_make.log 2>&1 || exit 1

echo Installing...
paco -p $TARGET "\
make install" \
        1> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1

TimeEnd
cd ..
RemoveSrcDir
PacoingDone

