#/bin/sh

. ./_clfsset.sh

APPNAME=dbus
VER=1.8.6
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo Configuring...
CC="gcc ${BUILD32}" USE_ARCH=32 PKG_CONFIG_PATH=${PKG_CONFIG_PATH32} \
  ./configure --prefix=/usr --sysconfdir=/etc \
    --libdir=/usr/lib --libexecdir=/usr/lib/dbus-1.0 \
    --localstatedir=/var --with-systemdsystemunitdir=/lib/systemd/system \
    --docdir=/usr/share/doc/dbus-1.8.6 \
	1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

mv -v /usr/lib/libdbus-1.so.* /lib \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
ln -sfv ../../lib/$(readlink /usr/lib/libdbus-1.so) /usr/lib/libdbus-1.so \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.

