#/bin/sh

. ./_clfsset.sh

APPNAME=linux
TARGET=$APPNAME-$LINUX_VER
TARGETBALL=$APPNAME-3.14.tar.xz
TARGETDIR=$APPNAME-3.14

cd $SRC

echo $TARGET

RemoveSrcDir

. $WRK/_extract.sh

cd $TARGETDIR

TimeStart

echo Patching..
xzcat $DLD/patch-$LINUX_VER.xz | patch -Np1 -i - \
        1> $LOG/$THISFILE.0_patch.log 2>&1 || exit 1

echo Making mrproper...
make mrproper \
        1> $LOG/$THISFILE.1_mrproper.log 2>&1 || exit 1

echo Making headers_check...
make headers_check \
        1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make INSTALL_HDR_PATH=/usr headers_install \
        1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
find /usr/include -name .install -or -name ..install.cmd | xargs rm -fv \
        1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.

