#/bin/sh

. ./_clfsset.sh

APPNAME=perl
VER=5.20.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

export BUILD_ZLIB=False
export BUILD_BZIP2=0

echo "127.0.0.1 localhost $(hostname)" > /etc/hosts

echo Configuring...
./configure.gnu --prefix=/usr \
   -Dvendorprefix=/usr \
   -Dman1dir=/usr/share/man/man1 \
   -Dman3dir=/usr/share/man/man3 \
   -Dpager="/bin/less -isR" \
   -Dcc="gcc ${BUILD32}" \
   -Dusethreads -Duseshrplib \
	1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
unset BUILD_ZLIB BUILD_BZIP2

mv -v /usr/bin/perl{,-32} \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
mv -v /usr/bin/perl5.20.0{,-32} \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.
