#/bin/sh

. ./_clfsset.sh

echo Configuring the system clock

cat > /etc/adjtime << "EOF"
0.0 0 0.0
0
LOCAL
EOF

timedatectl set-local-rtc 1

timedatectl set-timezone Asia/Tokyo

echo Configuring the Linux Console

cat > /etc/vconsole.conf << "EOF"
KEYMAP=jp106
FONT=
EOF

echo The Bash Shell Startup Files 

cat > /etc/profile << "EOF"
# Begin /etc/profile

source /etc/locale.conf

for f in /etc/bash_completion.d/*
do
  if [ -e ${f} ]; then source ${f}; fi
done
unset f

export INPUTRC=/etc/inputrc

# End /etc/profile
EOF

echo Setting Up Locale Information

cat > /etc/locale.conf << "EOF"
# Begin /etc/locale.conf

LANG=ja_JP.UTF-8

# End /etc/locale.conf
EOF

echo Creating the /etc/inputrc File

cat > /etc/inputrc << "EOF"
# Begin /etc/inputrc
# Modified by Chris Lynn <roryo@roryo.dynup.net>

# Allow the command prompt to wrap to the next line
set horizontal-scroll-mode Off

# Enable 8bit input
set meta-flag On
set input-meta On

# Turns off 8th bit stripping
set convert-meta Off

# Keep the 8th bit for display
set output-meta On

# none, visible or audible
set bell-style none

# All of the following map the escape sequence of the
# value contained inside the 1st argument to the
# readline specific functions

"\eOd": backward-word
"\eOc": forward-word

# for linux console
"\e[1~": beginning-of-line
"\e[4~": end-of-line
"\e[5~": beginning-of-history
"\e[6~": end-of-history
"\e[3~": delete-char
"\e[2~": quoted-insert

# for xterm
"\eOH": beginning-of-line
"\eOF": end-of-line

# for Konsole
"\e[H": beginning-of-line
"\e[F": end-of-line

# End /etc/inputrc
EOF

echo Creating the /etc/fstab File

cat > /etc/fstab << "EOF"
# Begin /etc/fstab

# file system  mount-point type options		dump	fsck
#                                                       order

/dev/sda3	/	ext4	defaults	1	1
/dev/sda1	/boot	ext4	defaults	1	1
/dev/sda2	swap	swap	pri=1		0	0

# End /etc/fstab
EOF

