#/bin/sh

CHAP=5
APPNAME=binutils
APPVER=.2
VER=2.25
TARGET=$APPNAME-$VER
TARGETBALL=${TARGET}.tar.bz2
TARGETDIR=$TARGET

. ./_lfsset.sh

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR
rm -fr binutils-build

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

mkdir ../binutils-build
cd ../binutils-build

echo \ \ Configuring...
CC=$LFS_TGT-gcc                \
AR=$LFS_TGT-ar                 \
RANLIB=$LFS_TGT-ranlib         \
../binutils-$VER/configure     \
    --prefix=/tools            \
    --disable-nls              \
    --disable-werror           \
    --with-lib-path=/tools/lib \
    --with-sysroot             \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1

echo \ \ Installing...
make install \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1

echo \ \ Cleaning..
make -C ld clean \
	1> $LOG/$CHAP.$TARGET.4_clean.log 2>&1

echo \ \ Making ld...
make -C ld LIB_PATH=/usr/lib:/lib \
	1> $LOG/$CHAP.$TARGET.5_make.log 2>&1

echo \ \ Copying...
cp ld/ld-new /tools/bin \
	1> $LOG/$CHAP.$TARGET.6_copy.log 2>&1

TimeEnd chap5

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR
rm -fr binutils-build

echo \ \ Done.

