#/bin/sh

CHAP=5
APPNAME=libstdc++
VER=4.9.2
TARGET=$APPNAME-$VER
TARGETBALL=gcc-$VER.tar.bz2
TARGETDIR=gcc-$VER

. ./_lfsset.sh

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR
rm -fr gcc-build

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

mkdir ../gcc-build
cd ../gcc-build

echo \ \ Configuring...
../gcc-$VER/libstdc++-v3/configure  \
    --host=$LFS_TGT                 \
    --prefix=/tools                 \
    --disable-multilib              \
    --disable-shared                \
    --disable-nls                   \
    --disable-libstdcxx-threads     \
    --disable-libstdcxx-pch         \
    --with-gxx-include-dir=/tools/$LFS_TGT/include/c++/$VER \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1

echo \ \ Installing...
make install \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1

TimeEnd chap5

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR && rm -fr gcc-build

echo \ \ Done.

