BOOTSCRIPTVER=20141224
SVNVER=20150118
LINUX_VER=3.18.2

case `uname -m` in
  i?86)
    export CPUBIT=32
    ;;
  x86_64)
    export CPUBIT=64
    ;;
  *)
    export CPUBIT=
    ;;
esac

LFS=/mnt/lfs
SRC=$LFS/sources/LFS
DLD=$LFS/download/LFS
WRK=$LFS/work/LFScripts/LFS
LOG=$WRK/log$CPUBIT
TME=$WRK/time$CPUBIT

mkdir -pv $LOG $TME
mkdir -pv $TME/chap{5,6,8}

function TimeStart() {
  START=`date +'%Y/%m/%d %H:%M:%S.%N'`
  return 0
}

function TimeEnd() {
  local DIR=$TME
  if test "$1" != ""; then
    DIR=$TME/$1
  fi
  END=`date +'%Y/%m/%d %H:%M:%S.%N'`

HOSTINFO=`uname -n`

  echo $1,$TARGET,$START,$END \
        >> $TME/_lfstime.txt
  echo $HOSTINFO,$TARGET,$START,$END \
        >> $DIR/$APPNAME.txt
}

