#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

VER=3.46
TARGET=man-pages-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

cd $TARGETDIR

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo \ \ Installing...
paco -p $TARGET "make install" \
	1> $LOG/$CHAP.$TARGET.1_install.log 2>&1 || exit 1

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo $CHAP, $TARGET, $START, $END \
	>> $TME/lfstime.txt

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

echo \ \ Done.

