#/bin/sh

CHAP=again

TARGET=chroot

LFS=/mnt/lfs
SRC=$LFS/sources/LFS
DLD=$LFS/download/LFS
WRK=$LFS/work/LFS
LOG=$LFS/work/LFS/log
ERR=$LFS/work/LFS/err
TME=$LFS/work/LFS/time

mkdir -pv $LOG $ERR $TME

mount -v --bind /dev $LFS/dev

mount -vt devpts devpts $LFS/dev/pts
mount -vt proc proc $LFS/proc
mount -vt sysfs sysfs $LFS/sys

if [ -h /dev/shm ]; then
   rm -f $LFS/dev/shm
   mkdir $LFS/dev/shm
fi

mount -vt tmpfs shm $LFS/dev/shm

chroot "$LFS" /tools/bin/env -i \
    HOME=/root TERM="$TERM" PS1='\u:\w\$ ' \
    PATH=/bin:/usr/bin:/sbin:/usr/sbin:/tools/bin \
    /tools/bin/bash --login +h

