#!/bin/sh

. ./_blfsset.sh

APPNAME=XML-Parser
VER=2.41
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh expat
. $WRK/_checkOptions.sh  libwww-perl
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

echo Perling...
perl Makefile.PL \
	1> $LOG/$TARGET.1_perl.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

echo Testing...
make test \
	1> $LOG/$TARGET.3_test.log 2>&1 || echo Error occured in testing

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.4_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

