#!/bin/sh

. ./_xorgset.sh

cat > /etc/profile.d/xorg.sh << "EOF"
XORG_PREFIX="/usr"
XORG_CONFIG="--prefix=$XORG_PREFIX --sysconfdir=/etc \
    --localstatedir=/var --disable-static "
export XORG_PREFIX XORG_CONFIG
EOF
chmod 644 /etc/profile.d/xorg.sh

porg -lp "Xorg-init" "\
touch /etc/profile.d/xorg.sh"

#cat >> /etc/profile.d/xorg.sh << "EOF"
#
#pathappend $XORG_PREFIX/bin PATH
#pathappend $XORG_PREFIX/lib/pkgconfig PKG_CONFIG_PATH
#pathappend $XORG_PREFIX/share/pkgconfig PKG_CONFIG_PATH
#export PATH PKG_CONFIG_PATH
#EOF

echo "${XORG_PREFIX}/lib" >> /etc/ld.so.conf

sed 's@/usr/X11R6@/usr/X11@g' -i /etc/man_db.conf

install -v -m755 -d $XORG_PREFIX
install -v -m755 -d $XORG_PREFIX/lib
#ln -s lib $XORG_PREFIX/lib64

mkdir -pv /etc/X11/xorg.conf.d
cat > /etc/X11/xorg.conf.d/10-keyboard.conf << "EOF"
Section "InputClass"
	Identifier	"Keyboard Defaults"
	MatchIsKeyboard	"yes"
	Option	"XkbRules"	"xorg"
	Option	"XkbModel"	"jp106"
	Option	"XkbLayout"	"jp"
	#Option	"XkbOptions"	"terminate:ctrl_alt_bksp"
	#Option	"PseudoModSpace" "50"
EndSection
EOF

porg -lp "Xorg-init" "\
touch /etc/X11/xorg.conf.d/10-keyboard.conf"

