#!/bin/sh

. ./_blfsset.sh

APPNAME=dmalloc
VER=5.5.2
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tgz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

unset MAKEFLAGS

TimeStart

cd $TARGETDIR

echo Patching from CBLFS...
patch -Np1 -i $DLD/dmalloc-$VER-Makefile.in-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1
echo Patching unofficial...
patch -Np1 -i $WRK/patch/dmalloc-$VER-undef-strdup.patch \
	1>> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

Configuring
./configure --prefix=/usr --enable-shlib --enable-threads \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

echo Making cxx...
make cxx \
	1>> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

echo Installing cxx...
porg -lp+ $TARGET 'make installcxx' \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "ln -svf libdmalloc.so.5.5.2 /usr/lib/libdmalloc.so" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

for lib in cxx th thcxx; do
    porg -lp+ $TARGET "ln -svf libdmalloc$lib.so.5.5.2 /usr/lib/libdmalloc$lib.so" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
done

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

