#!/bin/sh

APPNAME=docbook-sgml-dtd
VER=3.1
TARGET=$APPNAME-$VER
TARGETBALL=docbk31.zip
TARGETDIR=$TARGET

. ./_blfsset.sh

echo $TARGET

echo Check Required...
./_checkRequired.sh unzip || exit 1

if test "$1" == "check"; then
  exit 0
fi

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

mkdir -pv $TARGETDIR
cd $TARGETDIR

echo \ \ Extracting...
unzip $DLD/$TARGETBALL 1> /dev/null || exit 1

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

sed -i -e '/ISO 8879/d' \
    -e 's|DTDDECL "-//OASIS//DTD DocBook V3.1//EN"|SGMLDECL|g' \
    docbook.cat

install -v -d -m755 /usr/share/sgml/docbook/sgml-dtd-3.1
chown -R root:root . 
install -v docbook.cat /usr/share/sgml/docbook/sgml-dtd-3.1/catalog 
paco -p $TARGET "cp -v -af *.dtd *.mod *.dcl /usr/share/sgml/docbook/sgml-dtd-3.1"

paco -p+ $TARGET "\
install-catalog --add /etc/sgml/sgml-docbook-dtd-3.1.cat \
    /usr/share/sgml/docbook/sgml-dtd-3.1/catalog"

paco -p+ $TARGET "\
install-catalog --add /etc/sgml/sgml-docbook-dtd-3.1.cat \
    /etc/sgml/sgml-docbook.cat"

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo `cat /etc/lfs-release`,$TARGET,$START,$END \
        >> $TME/$APPNAME.txt

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

