#!/bin/sh

. ./_blfsset.sh

APPNAME=docbook-xsl
VER=1.78.1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh libxml2
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

rm -f /usr/share/xml/docbook/xsl-stylesheets-$VER/VERSION.xsl

TimeStart

cd $TARGETDIR

#echo \ \ Extracting doc...
#tar xf $DLD/docbook-xsl-doc-$VER.tar.bz2 --strip-components=1 \
#	 || (echo Tarball not found && exit 1)

echo Copying...
install -v -m755 -d /usr/share/xml/docbook/xsl-stylesheets-$VER \
	1> $LOG/$TARGET.1_copy.log 2>&1 || exit 1

porg -lp  $TARGET "\
cp -v -R VERSION common eclipse extensions fo highlighting html \
         htmlhelp images javahelp lib manpages params profiling \
         slides template tools website xhtml                    \
    /usr/share/xml/docbook/xsl-stylesheets-$VER" \
	1>> $LOG/$TARGET.1_copy.log 2>&1 || exit 1

porg -lp+ $TARGET "\
ln -s VERSION /usr/share/xml/docbook/xsl-stylesheets-$VER/VERSION.xsl" \
	1>> $LOG/$TARGET.1_copy.log 2>&1 || exit 1

porg -lp+ $TARGET "\
install -v -m644 -D README \
                    /usr/share/doc/docbook-xsl-$VER/README.txt" \
	1>> $LOG/$TARGET.1_copy.log 2>&1 || exit 1

porg -lp+ $TARGET "\
install -v -m755    RELEASE-NOTES* NEWS* \
                    /usr/share/doc/docbook-xsl-$VER" \
	1>> $LOG/$TARGET.1_copy.log 2>&1 || exit 1

porg -lp+ $TARGET "\
if [ ! -d /etc/xml ]; then install -v -m755 -d /etc/xml; fi"

porg -lp+ $TARGET "\
if [ ! -f /etc/xml/catalog ]; then
    xmlcatalog --noout --create /etc/xml/catalog
fi"

xmlcatalog --noout --add "rewriteSystem" \
           "http://docbook.sourceforge.net/release/xsl/$VER" \
           "/usr/share/xml/docbook/xsl-stylesheets-$VER" \
    /etc/xml/catalog

xmlcatalog --noout --add "rewriteURI" \
           "http://docbook.sourceforge.net/release/xsl/$VER" \
           "/usr/share/xml/docbook/xsl-stylesheets-$VER" \
    /etc/xml/catalog

xmlcatalog --noout --add "rewriteSystem" \
           "http://docbook.sourceforge.net/release/xsl/current" \
           "/usr/share/xml/docbook/xsl-stylesheets-$VER" \
    /etc/xml/catalog

xmlcatalog --noout --add "rewriteURI" \
           "http://docbook.sourceforge.net/release/xsl/current" \
           "/usr/share/xml/docbook/xsl-stylesheets-$VER" \
    /etc/xml/catalog

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

