#!/bin/sh

. ./_blfsset.sh

APPNAME=firefox
VER=33.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$APPNAME-$VER.source.tar.bz2
TARGETDIR=mozilla-release

echo $TARGET

. $WRK/_checkRequired.sh \
	alsa-lib gtk+-2 zip unzip
. $WRK/_checkOptions.sh  \
	icu libevent libvpx nspr nss sqlite yasm \
        curl dbus-glib doxygen gst-plugins-base \
        libnotify openjdk pulseaudio startup-notification \
        wget wireless_tools hunspell
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

$WRK/mk_mozconfig.sh

echo Making...
test $(uname -m) = "i686" && sed -i 's/enable-optimize/disable-optimize/' mozconfig || true

make -f client.mk \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

echo Installing...
paco -p $TARGET "\
make -f client.mk install INSTALL_SDK= " \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

mkdir -pv /usr/lib/mozilla/plugins

paco -p+ $TARGET "\
ln -sfv ../../mozilla/plugins /usr/lib/firefox-$VER/browser" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

mkdir -pv /usr/share/applications
mkdir -pv /usr/share/pixmaps

cat > /usr/share/applications/firefox.desktop << "EOF" &&
[Desktop Entry]
Encoding=UTF-8
Name=Firefox Web Browser
Comment=Browse the World Wide Web
GenericName=Web Browser
Exec=firefox %u
Terminal=false
Type=Application
Icon=firefox
Categories=GNOME;GTK;Network;WebBrowser;
MimeType=application/xhtml+xml;text/xml;application/xhtml+xml;application/vnd.mozilla.xul+xml;text/mml;x-scheme-handler/http;x-scheme-handler/https;
StartupNotify=true
EOF

paco -p+ $TARGET "\
ln -sfv /usr/lib/firefox-$VER/browser/icons/mozicon128.png \
        /usr/share/pixmaps/firefox.png" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone
