#!/bin/sh

. ../_blfsset.sh
. ./_gnomeset.sh

APPNAME=gnome-control-center
VER=3.6.3
TARGET=$APPNAME-$VER
TARGETBALL=$GNOMEDLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	gnome-menus gnome-online-accounts \
        gnome-settings-daemon libgtop shared-mime-info \
        accountsservice consolekit gnome-screensaver \
        polkit-gnome
. $WRK/_checkOptions.sh  \
	cups gnome-bluetooth ibus networkmanager
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#Patching
#patch -Np1 -i $GNOMEDLD/gnome-control-center-$VER-cups-1.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1
#echo Patching unofficial \(from gnome ML\)
#patch -Np1 -i $WRK/patch/gnome-control-center-$VER.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

Configuring
./configure --prefix=/usr \
	--sysconfdir=/etc \
$([ ${OPTION_cups} -ne 1 ] && echo --disable-cups) \
$([ ${OPTION_ibus} -ne 1 ] && echo --disable-ibus) \
        --disable-static \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

