#!/bin/sh

. ../_blfsset.sh
. ./_gnomeset.sh

APPNAME=gnome-session
VER=3.6.2
TARGET=$APPNAME-$VER
TARGETBALL=$GNOMEDLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	gconf gtk+-3 json-glib \
        upower \
        consolekit
. $WRK/_checkOptions.sh  \
	xmlto
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
            --libexecdir=/usr/lib/gnome-session \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

cat >> ~/.xinitrc << "EOF"
exec ck-launch-session dbus-launch --exit-with-session gnome-session
EOF

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

