#!/bin/sh

. ../_blfsset.sh
. ./_gnomeset.sh

APPNAME=gtkhtml
VER=4.6.4
TARGET=$APPNAME-$VER
TARGETBALL=$GNOMEDLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	enchant gnome-icon-theme gsettings-desktop-schemas \
        gtk+-3 iso-codes
. $WRK/_checkOptions.sh  libsoup
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

