#!/bin/sh

. ./_blfsset.sh

APPNAME=intltool
VER=0.50.2
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh XML-Parser
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET 'make install' \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

paco -p+ $TARGET "\
install -v -m644 -D doc/I18N-HOWTO \
    /usr/share/doc/intltool-$VER/I18N-HOWTO" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

cd ..
RemoveSrcDir
PacoingDone

