#!/bin/sh

. ./_blfsset.sh

VER=2.0.2
TARGET=libaacplus-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh unzip
. $WRK/_checkOptions.sh  fftw
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

echo Patching unofficial...
patch -Np1 -i $WRK/patch/libaacplus-$VER.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

Configuring
./autogen.sh \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1
./configure --prefix=/usr \
	$([ ${OPTION_fftw} -eq "1" ] && echo --with-fftw3 --with-fftw3-prefix=/usr) \
	1>> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

