#!/bin/sh

. ./_blfsset.sh

APPNAME=libdbusmenu-qt
VER=0.9.2
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	qt-4
. $WRK/_checkOptions.sh  \
	qjson doxygen
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

mkdir build
cd    build

echo \ \ Cmaking...
cmake -DCMAKE_INSTALL_PREFIX=$QTDIR \
      -DCMAKE_BUILD_TYPE=Release \
      -DWITH_DOC=OFF .. \
	1> $LOG/$TARGET.1_cmake.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ../..
RemoveSrcDir
PacoingDone

