#!/bin/sh

. ./_blfsset.sh

APPNAME=libgcrypt
VER=1.6.3
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	libgpg-error
. $WRK/_checkOptions.sh  \
	pth libcap
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

#if [ ${OPTION_libcap2} -eq "1" ]; then
#  export WITHCAP="--with-capabilities "
#else
#  export WITHCAP=""
#fi

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
	$([ ${OPTION_libcap} -eq 1 ] && echo --with-capabilities) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "\
make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

install -v -dm755   /usr/share/doc/libgcrypt-$VER
porg -lp+ $TARGET "\
install -v -m644    README doc/{README.apichanges,fips*,libgcrypt*} \
                    /usr/share/doc/libgcrypt-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

