#!/bin/sh

. ./_blfsset.sh

APPNAME=llvm
VER=3.5.0
VER_CFE=3.5.0
VER_CRT=3.5.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.src.tar.xz
TARGETDIR=$TARGET.src

unset MAKEFLAGS

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
        libffi python-2 \
	doxygen graphviz libxml2 texlive zip \
        ocaml sphinx valgrind
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

tar -xf $DLD/cfe-${VER_CFE}.src.tar.xz -C tools || exit 1
tar -xf $DLD/compiler-rt-${VER_CRT}.src.tar.xz -C projects || exit 1
mv tools/cfe-${VER_CFE}.src tools/clang
mv projects/compiler-rt-${VER_CRT}.src projects/compiler-rt

sed -e "s:/docs/llvm:/share/doc/llvm-$VER:" \
    -i Makefile.config.in

Configuring
CC=gcc  \
CXX=g++ \
./configure --prefix=/usr              \
            --sysconfdir=/etc          \
            --enable-libffi            \
            --enable-optimized         \
            --enable-shared            \
            --disable-assertions       \
            --disable-docs             \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "\
make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

for file in /usr/lib/lib{clang,LLVM,LTO}*.a
do
  test -f $file && chmod 644 $file
done

install -v -dm755 /usr/lib/clang-analyzer

for prog in scan-build scan-view
do
  paco -lp+ $TARGET "\
  cp -rfv tools/clang/tools/$prog /usr/lib/clang-analyzer/" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

  paco -lp+ $TARGET "\
  ln -sfv ../lib/clang-analyzer/$prog/$prog /usr/bin/" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
done

paco -lp+ $TARGET "\
ln -sfv /usr/bin/clang /usr/lib/clang-analyzer/scan-build/" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -lp+ $TARGET "\
mv -v /usr/lib/clang-analyzer/scan-build/scan-build.1 /usr/share/man/man1/" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

