#!/bin/sh

. ./_blfsset.sh

APPNAME=lm_sensors
VER=3.3.2
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

echo Check Required...
./_checkRequired.sh which || exit 1

if test "$1" == "check"; then
  exit 0
fi

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

echo \ \ Making...
make PREFIX=/usr BUILD_STATIC_LIB=0 \
  MANDIR=/usr/share/man \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p $TARGET "\
make PREFIX=/usr BUILD_STATIC_LIB=0 \
  MANDIR=/usr/share/man install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

mkdir -p /usr/share/doc/lm_sensors-$VER

paco -p+ $TARGET "\
cp -rf doc/* /usr/share/doc/lm_sensors-$VER"

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo `cat /etc/lfs-release`,$TARGET,$START,$END \
        >> $TME/$APPNAME.txt

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

