#!/bin/sh

. ./_blfsset.sh

APPNAME=nginx
VER=1.7.6
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	openssl
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

groupadd -g 25 nginx
useradd -c "Nginx Server" -d /dev/null -g nginx \
        -s /bin/false -u 25 nginx

TimeStart

cd $TARGETDIR

Configuring
    ./configure --prefix=/usr \
	--conf-path=/etc/nginx/nginx.conf \
        --error-log-path=/var/log/error.log \
	--http-log-path=/var/log/access.log \
	--pid-path=/var/run/nginx.pid \
	--lock-path=/var/lock \
	--user=nginx \
	--group=nginx \
	--http-fastcgi-temp-path=/tmp/fcgi \
	--http-client-body-temp-path=/tmp/cb \
	--http-proxy-temp-path=/tmp/proxy \
$([ ${OPTION_openssl} -eq 1 ] && echo --with-openssl=/usr) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

install -m755 -d /var/www/nginx-default
paco -p+ $TARGET "cp html/* /var/www/nginx-default" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone
