#!/bin/sh

. ./_blfsset.sh

APPNAME=sphinx
VER=1.1.3
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/Sphinx-$VER.tar.gz
TARGETDIR=Sphinx-$VER

echo $TARGET

. $WRK/_checkRequired.sh python docutils
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Installing
paco -p $TARGET "python ./setup.py install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

