#!/bin/sh

. ./_blfsset.sh

APPNAME=unbound
VER=1.5.1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	openssl
. $WRK/_checkOptions.sh  \
	libevent python-2 swig doxygen dnstap
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

groupadd -g 88 unbound 
useradd -c "Unbound DNS resolver" -d /var/lib/unbound -u 88 \
        -g unbound -s /bin/false unbound

Configuring
./configure --prefix=/usr \
            --sysconfdir=/etc \
            --with-pidfile=/run/unbound.pid \
            --disable-static \
            $([ ${OPTION_libevent} -eq 1 ] && echo --with-libevent) \
            $([ ${OPTION_swig} -eq 1 ] && echo --with-pyunbound) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
mv -v /usr/sbin/unbound-host /usr/bin" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

