#!/bin/sh

. ./_xfceset.sh

APPNAME=tumbler
VER=0.1.29
TARGET=$APPNAME-$VER
TARGETBALL=$XFCEDLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	dbus-glib intltool
. $WRK/_checkOptions.sh  \
	curl ffmpegthumbnailer gst-plugins-base-0 \
        freetype gdk-pixbuf gtk-doc libjpeg-turbo \
        libgsf libopenraw libpng poppler
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr --sysconfdir=/etc \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

