#/bin/sh

. ./_clfsset.sh

APPNAME=libcap
VER=2.24
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo Making...
make CC="gcc ${BUILD64}" \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make lib=lib64 install \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
chmod -v 755 /lib64/libcap.so.2.24 \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
ln -sfv ../../lib64/$(readlink /lib64/libcap.so) /usr/lib64/libcap.so \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
rm -v /lib64/libcap.so \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
mv -v /lib64/libcap.a /usr/lib64 \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.

