#/bin/sh

. ./_clfsset.sh

APPNAME=vim
VER=7.4
TARGET=vim-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=vim74

cd $SRC

echo $TARGET

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Patching...
patch -Np1 -i $DLD/vim-$VER-branch_update-7.patch \
	1> $LOG/$THISFILE.0_patch.log 2>&1 || exit 1

echo '#define SYS_VIMRC_FILE "/etc/vimrc"' >> src/feature.h

echo Configuring...
CC="gcc ${BUILD64}" CXX="g++ ${BUILD64}" \
  ./configure --prefix=/usr \
	1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

ln -sv vim /usr/bin/vi \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

ln -sv ../vim/vim74/doc /usr/share/doc/vim-7.4 \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

cat > /etc/vimrc << "EOF"
" Begin /etc/vimrc

set nocompatible
set backspace=2
set ruler
syntax on
if (&term == "iterm") || (&term == "putty")
  set background=dark
endif

" End /etc/vimrc
EOF
touch /etc/vimrc \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.
